# $NetBSD: cond-func-defined.mk,v 1.7 2020/11/15 14:07:53 rillig Exp $
#
# Tests for the defined() function in .if conditions.

DEF=		defined
${:UA B}=	variable name with spaces

.if !defined(DEF)
.  error
.endif

# Horizontal whitespace (space tab) after the opening parenthesis is ignored.
.if !defined( 	DEF)
.  error
.endif

# Horizontal whitespace (space tab) before the closing parenthesis is ignored.
.if !defined(DEF 	)
.  error
.endif

# The argument of a function must not directly contain whitespace.
.if !defined(A B)
.  error
.endif

# If necessary, the whitespace can be generated by a variable expression.
.if !defined(${:UA B})
.  error
.endif

# Parse error: missing closing parenthesis; see ParseFuncArg.
.if defined(DEF
.  error
.else
.  error
.endif

# Variables from .for loops are not defined.
# See directive-for.mk for more details.
.for var in value
.  if defined(var)
.    error
.  else
.    info In .for loops, variable expressions for the loop variables are
.    info substituted at evaluation time.  There is no actual variable
.    info involved, even if it feels like it.
.  endif
.endfor

all:
	@:;
