/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XKeyboardState
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 64;
    }

    public int getDataSize() {
        return XKeyboardState.getSize();
    }

    public long getPData() {
        return this.pData;
    }

    XKeyboardState(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    XKeyboardState() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XKeyboardState.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_key_click_percent() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_key_click_percent(int n) {
        log.finest("");
        Native.putInt(this.pData + 0L, n);
    }

    public int get_bell_percent() {
        log.finest("");
        return Native.getInt(this.pData + 4L);
    }

    public void set_bell_percent(int n) {
        log.finest("");
        Native.putInt(this.pData + 4L, n);
    }

    public int get_bell_pitch() {
        log.finest("");
        return Native.getInt(this.pData + 8L);
    }

    public void set_bell_pitch(int n) {
        log.finest("");
        Native.putInt(this.pData + 8L, n);
    }

    public int get_bell_duration() {
        log.finest("");
        return Native.getInt(this.pData + 12L);
    }

    public void set_bell_duration(int n) {
        log.finest("");
        Native.putInt(this.pData + 12L, n);
    }

    public long get_led_mask() {
        log.finest("");
        return Native.getLong(this.pData + 16L);
    }

    public void set_led_mask(long l) {
        log.finest("");
        Native.putLong(this.pData + 16L, l);
    }

    public int get_global_auto_repeat() {
        log.finest("");
        return Native.getInt(this.pData + 24L);
    }

    public void set_global_auto_repeat(int n) {
        log.finest("");
        Native.putInt(this.pData + 24L, n);
    }

    public byte get_auto_repeats(int n) {
        log.finest("");
        return Native.getByte(this.pData + 28L + (long)(n * 1));
    }

    public void set_auto_repeats(int n, byte by) {
        log.finest("");
        Native.putByte(this.pData + 28L + (long)(n * 1), by);
    }

    public long get_auto_repeats() {
        log.finest("");
        return this.pData + 28L;
    }

    String getName() {
        return "XKeyboardState";
    }

    String getFieldsAsString() {
        String string = "";
        string = string + "key_click_percent = " + this.get_key_click_percent() + ", ";
        string = string + "bell_percent = " + this.get_bell_percent() + ", ";
        string = string + "bell_pitch = " + this.get_bell_pitch() + ", ";
        string = string + "bell_duration = " + this.get_bell_duration() + ", ";
        string = string + "led_mask = " + this.get_led_mask() + ", ";
        string = string + "global_auto_repeat = " + this.get_global_auto_repeat() + ", ";
        string = string + "{" + this.get_auto_repeats(0) + " " + this.get_auto_repeats(1) + " " + this.get_auto_repeats(2) + " " + this.get_auto_repeats(3) + " " + this.get_auto_repeats(4) + " " + this.get_auto_repeats(5) + " " + this.get_auto_repeats(6) + " " + this.get_auto_repeats(7) + " " + this.get_auto_repeats(8) + " " + this.get_auto_repeats(9) + " " + this.get_auto_repeats(10) + " " + this.get_auto_repeats(11) + " " + this.get_auto_repeats(12) + " " + this.get_auto_repeats(13) + " " + this.get_auto_repeats(14) + " " + this.get_auto_repeats(15) + " " + this.get_auto_repeats(16) + " " + this.get_auto_repeats(17) + " " + this.get_auto_repeats(18) + " " + this.get_auto_repeats(19) + " " + this.get_auto_repeats(20) + " " + this.get_auto_repeats(21) + " " + this.get_auto_repeats(22) + " " + this.get_auto_repeats(23) + " " + this.get_auto_repeats(24) + " " + this.get_auto_repeats(25) + " " + this.get_auto_repeats(26) + " " + this.get_auto_repeats(27) + " " + this.get_auto_repeats(28) + " " + this.get_auto_repeats(29) + " " + this.get_auto_repeats(30) + " " + this.get_auto_repeats(31) + " " + "}";
        return string;
    }
}

