/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.wsdl;

import com.sun.xml.internal.ws.wsdl.parser.Binding;
import com.sun.xml.internal.ws.wsdl.parser.Port;
import com.sun.xml.internal.ws.wsdl.parser.RuntimeWSDLParser;
import com.sun.xml.internal.ws.wsdl.parser.Service;
import com.sun.xml.internal.ws.wsdl.parser.WSDLDocument;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.WebServiceException;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLContext {
    private final URL orgWsdlLocation;
    private String targetNamespace;
    private final WSDLDocument wsdlDoc;

    public WSDLContext(URL uRL, EntityResolver entityResolver) throws WebServiceException {
        assert (entityResolver != null);
        if (uRL == null) {
            throw new WebServiceException("No WSDL location Information present, error");
        }
        this.orgWsdlLocation = uRL;
        try {
            this.wsdlDoc = RuntimeWSDLParser.parse(uRL, entityResolver);
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
        catch (SAXException sAXException) {
            throw new WebServiceException(sAXException);
        }
    }

    public URL getWsdlLocation() {
        return this.orgWsdlLocation;
    }

    public String getOrigURLPath() {
        return this.orgWsdlLocation.getPath();
    }

    public QName getServiceQName() {
        return this.wsdlDoc.getFirstServiceName();
    }

    public boolean contains(QName qName) {
        return this.wsdlDoc.getServices().containsKey(qName);
    }

    public String getEndpoint(QName qName) {
        Iterator iterator;
        if (qName == null) {
            throw new WebServiceException("Service unknown, can not identify ports for an unknown Service.");
        }
        Service service = this.wsdlDoc.getService(qName);
        String string = null;
        if (service != null && (iterator = service.entrySet().iterator()).hasNext()) {
            Port port = (Port)iterator.next().getValue();
            string = port.getAddress();
        }
        if (string == null) {
            throw new WebServiceException("Endpoint not found. Check WSDL file to verify endpoint was provided.");
        }
        return string;
    }

    public QName getPortName() {
        return this.wsdlDoc.getFirstPortName();
    }

    public String getBindingID(QName qName, QName qName2) {
        return this.getWsdlDocument().getBindingId(qName, qName2);
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String string) {
        this.targetNamespace = string;
    }

    public Set<QName> getPortsAsSet(QName qName) {
        Service service = this.wsdlDoc.getService(qName);
        if (service != null) {
            return service.keySet();
        }
        return null;
    }

    public boolean contains(QName qName, QName qName2) {
        Service service = this.wsdlDoc.getService(qName);
        if (service != null) {
            Iterator iterator = service.entrySet().iterator();
            while (iterator.hasNext()) {
                Port port = (Port)iterator.next().getValue();
                if (!port.getName().equals(qName2)) continue;
                return true;
            }
        }
        return false;
    }

    public QName getFirstServiceName() {
        return this.wsdlDoc.getFirstServiceName();
    }

    public Set<QName> getAllServiceNames() {
        return this.wsdlDoc.getServices().keySet();
    }

    public WSDLDocument getWsdlDocument() {
        return this.wsdlDoc;
    }

    public Binding getWsdlBinding(QName qName, QName qName2) {
        if (this.wsdlDoc == null) {
            return null;
        }
        return this.wsdlDoc.getBinding(qName, qName2);
    }

    public String getEndpoint(QName qName, QName qName2) {
        Service service = this.wsdlDoc.getService(qName);
        if (service != null) {
            Port port = (Port)service.get(qName2);
            if (port != null) {
                return port.getAddress();
            }
            throw new WebServiceException("No ports found for service " + qName);
        }
        throw new WebServiceException("Service unknown, can not identify ports for an unknown Service.");
    }
}

