/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import sun.security.provider.SystemIdentity;
import sun.security.x509.X509Cert;
import sun.tools.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarVerifierStream
extends ZipInputStream {
    private JarEntry current;
    private Hashtable<String, Vector<SystemIdentity>> verified = new Hashtable();
    private JarInputStream jis;
    private Manifest man = null;
    private ArrayList<CertCache> certCache = null;

    public JarVerifierStream(InputStream inputStream) throws IOException {
        super(inputStream);
        this.jis = new JarInputStream(inputStream);
    }

    @Override
    public void close() throws IOException {
        this.jis.close();
    }

    @Override
    public void closeEntry() throws IOException {
        this.jis.closeEntry();
    }

    @Override
    public synchronized ZipEntry getNextEntry() throws IOException {
        this.current = (JarEntry)this.jis.getNextEntry();
        return this.current;
    }

    @Override
    public int read() throws IOException {
        int n = this.jis.read();
        if (n == -1) {
            this.addIds();
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.jis.read(byArray, n, n2);
        if (n3 == -1) {
            this.addIds();
        }
        return n3;
    }

    private void addIds() {
        Vector<SystemIdentity> vector;
        Certificate[] certificateArray;
        if (this.current != null && (certificateArray = this.current.getCertificates()) != null && (vector = this.getIds(certificateArray)) != null) {
            this.verified.put(this.current.getName(), vector);
        }
    }

    public Hashtable getVerifiedSignatures() {
        if (this.verified.isEmpty()) {
            return null;
        }
        return this.verified;
    }

    public Enumeration getBlocks() {
        if (this.verified.isEmpty()) {
            return null;
        }
        return new Enumeration(){

            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() {
                return null;
            }
        };
    }

    public Hashtable getNameToHash() {
        return null;
    }

    public Manifest getManifest() {
        if (this.man == null) {
            try {
                java.util.jar.Manifest manifest = this.jis.getManifest();
                if (manifest == null) {
                    return null;
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                manifest.write(byteArrayOutputStream);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.man = new Manifest(byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.man;
    }

    protected Vector<SystemIdentity> getIds(Certificate[] certificateArray) {
        CertCache certCache;
        int n;
        if (certificateArray == null) {
            return null;
        }
        if (this.certCache == null) {
            this.certCache = new ArrayList();
        }
        for (n = 0; n < this.certCache.size(); ++n) {
            certCache = this.certCache.get(n);
            if (!certCache.equals(certificateArray)) continue;
            return certCache.ids;
        }
        certCache = new CertCache();
        certCache.certs = certificateArray;
        if (certificateArray.length > 0) {
            for (n = 0; n < certificateArray.length; ++n) {
                try {
                    X509Certificate x509Certificate = (X509Certificate)certificateArray[n];
                    Principal principal = x509Certificate.getSubjectDN();
                    final SystemIdentity systemIdentity = new SystemIdentity(principal.getName(), null);
                    byte[] byArray = x509Certificate.getEncoded();
                    X509Cert x509Cert = new X509Cert(byArray);
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>((java.security.Certificate)x509Cert){
                            final /* synthetic */ java.security.Certificate val$oldC;
                            {
                                this.val$oldC = certificate;
                            }

                            @Override
                            public Void run() throws KeyManagementException {
                                systemIdentity.addCertificate(this.val$oldC);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw (KeyManagementException)privilegedActionException.getException();
                    }
                    if (certCache.ids == null) {
                        certCache.ids = new Vector();
                    }
                    certCache.ids.addElement(systemIdentity);
                    continue;
                }
                catch (KeyManagementException keyManagementException) {
                    continue;
                }
                catch (IOException iOException) {
                    continue;
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    // empty catch block
                }
            }
        }
        this.certCache.add(certCache);
        return certCache.ids;
    }

    static class CertCache {
        Certificate[] certs;
        Vector<SystemIdentity> ids;

        CertCache() {
        }

        boolean equals(Certificate[] certificateArray) {
            int n;
            boolean bl;
            int n2;
            if (this.certs == null) {
                return certificateArray == null;
            }
            if (certificateArray == null) {
                return false;
            }
            for (n2 = 0; n2 < certificateArray.length; ++n2) {
                bl = false;
                for (n = 0; n < this.certs.length; ++n) {
                    if (!certificateArray[n2].equals(this.certs[n])) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            for (n2 = 0; n2 < this.certs.length; ++n2) {
                bl = false;
                for (n = 0; n < certificateArray.length; ++n) {
                    if (!this.certs[n2].equals(certificateArray[n])) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            return true;
        }
    }
}

